##############################################################################
#
# Copyright (c) 1999-2000 Chui Tey
# All rights reserved. Written by Chui Tey <teyc@bigfoot.com>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission
#
# Disclaimer
#
#   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
#   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#   IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
#   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# In accordance with the license provided for by the software upon
# which some of the source code has been derived or used, the following
# acknowledgement is hereby provided:
#
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
#
##############################################################################

__doc__ = '''Product ZGDChart'''
__version__ = "0.6.2"

try:
	from ImageFile import ImageFile
	import ZGDChart
	import ColorPickerTag

	def initialize(context):

		context.registerClass(
			ZGDChart.ZGDChart,
			permission   = 'Add ZGDCharts',
			constructors = (	ZGDChart.manage_addZGDChartForm,
						ZGDChart.manage_addZGDChart),
			icon='icon.gif',
			)

		context.registerBaseClass(ZGDChart.ZGDChart)
		# the following lines fail for Zope 2.1.6, suppress them for now.
		context.registerHelp()
		context.registerHelpTitle('ZGDChart')

		try:
			from Products.ZBabel import ZBabelTag
		except:
			import NoBabelTag


	# Define shared web objects that are used by products.
	# This is usually (always ?) limited to images used 
	# when displaying an object in contents lists.
	# These objects are accessed as:
	#   <!--#var SCRIPT_NAME-->/misc_/Product/name
	misc_={
		'Main'        : ImageFile('icon.gif',globals()),
		'chart_types' : ZGDChart.ZGDChart.chart_types
	}

except:
	
	import traceback
	traceback.print_exc()
